# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Test.pm) perl(Text/CSV_XS.pm) perl(URI/Escape.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.23
%define module_name Splunklib
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.23
Release: alt1
Summary: the Splunk SDK to create custom commands in Perl
Group: Development/Perl
License: artistic
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GO/GOMOR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
#
   # Simple base64 custom command to encode/decode Base64
   #
   use FindBin qw($Bin);
   use lib "$Bin/lib";

   use Splunklib::Intersplunk qw(readResults outputResults isGetInfo outputGetInfo);

   # GetInfo support
   # @ARGV example: "__GETINFO__ field=_raw action=encode"
   if (isGetInfo(\@ARGV)) {
      outputGetInfo(undef, \*STDOUT);
      exit(0);
   }

   # @ARGV example: "field=_raw action=encode"
   my $field = '_raw';    # Default to encode/decode _raw
   my $action = 'encode'; # Default to encode
   for my $arg (@ARGV) {
      my ($k, $v) = split(/=/, $arg);
      if    ($k eq 'field')  { $field  = $v; }
      elsif ($k eq 'action') { $action = $v; }
   }

   my $ary = readResults(\*STDIN, undef, 1);
   my $results = $ary->[0];
   my $header = $ary->[1];
   my $lookup = $ary->[2];

   use MIME::Base64;

   for my $result (@$results) {
      if ($action eq 'encode') {
         $result->[$lookup->{$new_field}] = encode_base64($result->[$lookup->{$field}], '');
      }
      else {
         $result->[$lookup->{$new_field}] = decode_base64($result->[$lookup->{$field}]);
      }
   }

   outputResults($ary, undef, undef, '\n', \*STDOUT);
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE.Artistic LICENSE examples
%perl_vendor_privlib/S*

%changelog
