%define module_name Spreadsheet-Read-Ingester
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Copy.pm) perl(File/Signature.pm) perl(File/Spec.pm) perl(File/UserConfig.pm) perl(Log/Log4perl/Shortcuts.pm) perl(Spreadsheet/Read.pm) perl(Storable.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Text/CSV_PP.pm) perl(base.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.010
Release: alt1
Summary: ingest and save csv and spreadsheet data to a perl data structure to avoid reparsing
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/ST/STEVIED/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is intended to be a drop-in replacement for the Spreadsheet::Read manpage and
is a simple, unobtrusive wrapper for it.

Parsing spreadsheet and csv data files is time consuming, especially with large
data sets. If a data file is ingested more than once, much time and processing
power is wasted reparsing the same data. To avoid reparsing, this module uses
the Storable manpage to save a parsed version of the data to disk when a new file is
ingested. All subsequent ingestions are retrieved from the stored Perl data
structure. Files are saved in the directory determined by the File::UserConfig manpage
and is a function of the user's OS.

The stored data file names are the unique file signatures for the raw data file.
The signature is used to detect if the original file changed, in which case the
data is reingested from the raw file and a new parsed file is saved using an
updated file signature. Arguments passed to the constructor are appended to the
name of the file to ensure different parse options are accounted for. Parsed
data files are kept indefinitely but can be deleted with the `cleanup()'
method.

Consult the the Spreadsheet::Read manpage documentation for accessing the data object
returned by this module.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/S*

%changelog
