%define module_name Statistics-ANOVA-Page
# BEGIN SourceDeps(oneline):
BuildRequires: perl(List/AllUtils.pm) perl(Math/Cephes.pm) perl(Module/Build.pm) perl(Statistics/Data.pm) perl(Statistics/Data/Rank.pm) perl(Statistics/Zed.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Nonparametric analysis of variance by ranks for trend across dependent variables (Page and sign tes...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RG/RGARTON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Calculates Page statistics for nonparametric analysis of variance across given orders of dependent variables. Ranks are computed exactly as for the Friedman test, but the ranks are weighted according to the ordinal position of the group/level to which they pertain. Also, the test of significance is based on a standardized value, with the *p*-value read off the normal distribution. Similarly to the relationship between the Kruskal-Wallis and Jonckheere-Terpstra tests for non-dependent observations, the Friedman test returns the same value regardless of the ordinality of the variables as levels, but the Page test tests ranks in association with the ordinality of the variables (as levels rather than groups). These are weighted according to their Perl sort { $a <=> $b} order, so they should have sort-able names that reflect the ordering of the variables.

With only two groups, the test statistic is equivalent to that provided by a sign test.

Build tests include comparison of return values with published data, viz. from Hollander and Wolfe (1999, p. 286ff); passing these tests means the results agree.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
