# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Math/Cephes.pm) perl(Module/Build.pm) perl(Statistics/MVA.pm) perl(Test/More.pm) perl(Text/SimpleTable.pm) perl(the.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_version 0.0.2
%define module_name Statistics-MVA-BayesianDiscrimination
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.2
Release: alt1
Summary: Two-Sample Linear Discrimination Analysis with Posterior Probability Calculation.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DS/DSTH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Discriminant analysis is a procedure for classifying a set of observations each with k variables into predefined classes such as to allow the
determination of the class of new observations based upon the values of the k variables for these new observations. Group membership based on linear combinations of the variables. From the set of observations where group membership is know the procedure constructs a set of linear functions, termed
discriminant functions, such that: 

    L = B[0] + B[1] * x1 + B[2] * x2 +... ... + B[n] * x_n

Where B[0] is a constant, B[n's] are discriminant coefficients and x's are the input variables. These discriminant functions
(there is one for each group - consequently as this module only analyses data for two groups atm it generates two such
discriminant functions.

Before proceeding with the analysis you should: (1) Perform Bartlett-Es test to see if the covariance matrices of the data
are homogenous for the populations used (see the Statistics::MVA::Bartlett manpage. If they are not homogenous you should use Quadratic Discrimination analysis.
(2) test for equality of the group means using Hotelling's T^2 (see the Statistics::MVA::HotellingTwoSample manpage or MANOVA. If
the groups do not differ significantly it is extremely unlikely that discrimination analysis with generate any useful
discrimination rules. (3) Specify the prior probabilities. This module allows you to do this in several ways - see
the priors entry elsewhere in this document.

This class automatically generates the discrimination coefficients at part of object construction. You can then either
use the `output' method to access these values or use the `discriminate' method to apply the equations to a new
observation. Both of these methods are context dependent - see the METHODS entry elsewhere in this document. See
http://en.wikipedia.org/wiki/Linear_discriminant_analysis for further details.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
