%define module_name Statistics-Sequences
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Statistics/Data.pm) perl(Statistics/Lite.pm) perl(String/Numeric.pm) perl(Test/More.pm) perl(Text/SimpleTable.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: Manage sequences (ordered list of literals) for testing their runs, joins, turns, trinomes, potenti...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RG/RGARTON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Loading, updating and accessing data as ordered list of literal scalars (numbers, strings) for statistical tests of their sequential structure via Statistics::Sequences::Joins, Statistics::Sequences::Pot, Statistics::Sequences::Runs, Statistics::Sequences::Turns and Statistics::Sequences::Vnomes. Note that none of these sub-modules are installed by default; to use this module as intended, install one or more of these sub-modules.

To access the tests, use this base module to create a Statistics::Sequences object with new, then load data into it and access each test by calling the test method, specifying the stat attribute: either joins, pot, runs, turns or vnomes, where the relevant sub-module is installed. This allows running several tests on the same data, as the data are immediately available to each test (of joins, pot, runs, turns or vnomes). See the SYNOPSIS for a simple example. 

Alternatively, use each sub-module directly, and restrict analyses to the sub-module's test; this module is used implicitly as their base. That is, to perform a test of one type (e.g., runs), use the relevant sub-package, load data via its constructor; see the SYNOPSIS for the particular test, i.e., Joins, Pot, Runs, Turns or Vnomes. You won't be able to access other tests of the same data by this approach, unless you create another object for that test, and then specifically pass the data from the earlier object into the new one.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
