%define module_name Statistics-Sequences-Runs
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Array/Compare.pm) perl(List/AllUtils.pm) perl(Module/Build.pm) perl(Number/Misc.pm) perl(Statistics/Sequences.pm) perl(Statistics/Zed.pm) perl(String/Numeric.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.22
Release: alt1
Summary: observed, expected and variance counts, deviation and combinatorial tests, of Wald-type runs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RG/RGARTON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A Wald-type run is a sequence of identical events on 1 or more consecutive trials. For example, in a signal-detection test with sequence over time of match (H) and miss (M) events like H-H-M-H-M-M-M-M-H, there are 5 runs: 3 Hs, 2 Ms. This number of runs over time between two events can be compared with the number expected to occur by chance over the number of trials, and variance has also been worked out (see REFERENCES).

More runs than expected ("negative serial dependence") can denote irregularity, instability, mixing up of alternatives - lack of prejudice, even. Fewer runs than expected ("positive serial dependence") can denote cohesion, insulation, isolation of alternatives - loneliness, even. Both can indicate sequential dependency: either negative (a bias to produce too many alternations), or positive (a bias to produce too many repetitions).

The distribution of runs is asymptotically normal, and a deviation-based test of extra-chance occurrence when at least one alternative has more than 20 occurrences (Siegal rule), or both event occurrences exceed 10 (Kelly, 1982), is conventionally considered reliable; otherwise, consider exact test option.

Have non-dichotomous, continuous or multinomial data? See Statistics::Data::Dichotomize for how to prepare non-dichotomous data, whether numerical or made up of categorical events, for test of runs.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
