%define module_version 0.20
%define module_name Statistics-Sequences-Vnomes
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Combinatorics.pm) perl(Math/Cephes.pm) perl(Module/Build.pm) perl(Statistics/Lite.pm) perl(Statistics/Sequences.pm) perl(Statistics/Zed.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.20
Release: alt1
Summary: The Serial Test (psi-square) and Generalized Serial Test (delta psi-square) for equiprobability of ...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RG/RGARTON/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Implements tests of the independence of successive elements of a sequence of data: serial tests for v-nomes (a.k.a *v*-plets or, for binary data, *v*-bits) - singlets/monobits, dinomes/doublets, trinomes/triplets, etc.. Test are of variations in sub-sequence length *v* that are equally likely for the sampled sequence. For example, a sequence sampled from a "heads'n'tails" (H and T) distribution can be tested for its equal representation of the trinomes HTH, HTT, TTT, THT, and so on. Counting up these v-nomes at all points in the sequence, permitting overlaps, yields a statistic - psi-square - that is approximately distributed as *chi*-square; the Kendall-Babington Smith statistic.

However, because these counts are not independent (given the overlaps), Good's Generalized Serial Test is the default test-statistic returned by this module's test routine: It computes psi-square by differencing, viz., in relation to not only the specified length, or value of *v*, but also its value for the first two prior lengths of *v*, yielding a statistic, delta-square-psi-square (the "second backward difference" measure) that is *exactly* distributed as *chi*-square.

The test is suitable for multi-state data, not only the binary, dichotomous sequence suitable for the runs or joins tests. It can also be used to test that the individual elements in the list are uniformly distributed, that the states are equally represented, i.e., as a *chi*-square-based frequency test (a.k.a. test of uniformity, equiprobability, equidistribution). This is done by giving a length of 1, i.e., testing for mononomes.

Note that this is *not* the so-called serial test described by Knuth (1998, Ch. 2), which involves non-overlapping pairs of sequences.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
