%define module_name Steemit-WsClient
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/RIPEMD160.pm) perl(Data/Dumper.pm) perl(Date/Calc.pm) perl(Digest/SHA.pm) perl(IO/Socket/SSL.pm) perl(Math/BigInt.pm) perl(Math/BigInt/GMP.pm) perl(Math/EllipticCurve/Prime.pm) perl(Modern/Perl.pm) perl(Module/Build.pm) perl(Mojo/Base.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: perl lirary for interacting with the steemit websocket services!
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SN/SNKOEHN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Quick summary of what the module does.

Perhaps a little code snippet.

    use Steemit::WsClient;

    my $foo = Steemit::WsClient->new();
    my $steem = Steemit::WsClient->new( url => 'https://some.steemit.d.node.address');

    say "Initialized Steemit::WsClient client with url ".$steem->url;

    #get the last 99 discussions with the tag utopian-io
    #truncate the body since we dont care here
    my $discussions = $steem->get_discussions_by_created({
          tag => 'utopian-io',
          limit => 99,
          truncate_body => 100,
    });

    #extract the author names out of the result
    my @author_names = map { $_->{author} } @$discussions;
    say "last 99 authors: ".join(", ", @author_names);

    #load the author details
    my $authors = $steem->get_accounts( [@author_names] );
    #say Dumper $authors->[0];

    #calculate the reputation average
    my $reputation_sum = 0;
    for my $author ( @$authors ){
       $reputation_sum += int( $author->{reputation} / 1000_000_000 );
    }

    say "Average reputation of the last 99 utopian authors: ". ( int( $reputation_sum / scalar(@$authors) )  / 100 );

%prep
%setup -q -n perlSteemit-%{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md ignore.txt Changes examples
%perl_vendor_privlib/S*

%changelog
