# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(IPC/System/Simple.pm) perl(Mojolicious.pm) perl(Moose.pm) perl(Path/Tiny.pm) perl(Stenciller.pm) perl(String/Cushion.pm) perl(Syntax/Feature/Qi.pm) perl(Test/Differences.pm) perl(Test/Mojo/Trim.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(Types/Path/Tiny.pm) perl(syntax.pm)
# END SourceDeps(oneline)
%define module_name Stenciller-Plugin-ToMojoliciousTest
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0103
Release: alt1
Summary: Create Mojolicious tests from text files parsed with Stenciller
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Stenciller-Plugin-ToMojoliciousTest

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CS/CSSON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Stenciller::Plugin::ToMojoliciousTest is a the Stenciller manpage plugin that transforms stencils to Mojolicious tests.

If you build your distribution with the Dist::Zilla manpage the the Dist::Zilla::Plugin::Stenciller::MojoliciousTests manpage plugin is an easy way to use this class.

If the text file looks like this:

    == stencil ==

    --input--
        %%= link_to 'Example', 'http://www.example.com/'
        %%= form_for '01_test_1'
    --end input--

    --output--
        <a href="http://www.example.com/">Example</a>
        <form action="/01_test_1"></form>
    --end output--

And the template file like this:

    use 5.10.1;
    use strict;
    use warnings;
    use Test::More;
    use Test::Warnings;
    use Test::Mojo::Trim;
    use Mojolicious::Lite;

    use if $ENV{'AUTHOR_TESTING'}, 'Test::Warnings';

    my $test = Test::Mojo::Trim->new;

Then `$contents' will contain this:

        use 5.10.1;
        use strict;
        use warnings;
        use Test::More;
        use Test::Warnings;
        use Test::Mojo::Trim;
        use Mojolicious::Lite;

        use if $ENV{'AUTHOR_TESTING'}, 'Test::Warnings';

        my $test = Test::Mojo::Trim->new;


        # test from line 1 in 01-test.stencil

        my $expected_01_test_1 = qq{    <a href="http://www.example.com/">Example</a>
    <form action="/01_test_1"></form>};

        get '/01_test_1' => '01_test_1';

        $test->get_ok('/01_test_1')->status_is(200)->trimmed_content_is($expected_01_test_1, 'Matched trimmed content in 01-test.stencil, line 1');

        done_testing();

        __DATA__

        @@ 01_test_1.html.ep

            %%= link_to 'Example', 'http://www.example.com/'

            %%= form_for '01_test_1'

Do note that the generated tests currently are hardcoded to use `trimmed_content_is' from `Test::Mojo::Trim'. This might change in the future.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/S*

%changelog
