# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dump.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/XSHeaders.pm) perl(IO/File.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/More.pm) perl(parent.pm) perl(strict.pm) perl(threads.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Storable-Improved
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.3
Release: alt1
Summary: Storable improved with core flaws mitigated
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JD/JDEGUEST/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
the Storable::Improved manpage is a drop-in replacement for the Storable manpage. It is a thin module inheriting from the Storable manpage and mitigating some of the Storable manpage core flaws that have been pointed out to the development team (See the section on "SEE ALSO"), but not addressed mostly due their unwillingness to do so. Hence, this module offers the implementation initially suggested.

As the Storable manpage documentation states, "the the Storable manpage package brings persistence to your Perl data structures containing `SCALAR', `ARRAY', `HASH' or `REF' objects, i.e. anything that can be conveniently stored to disk and retrieved at a later time."

the Storable::Improved manpage provides an opportunity to support `GLOB'-based objects as well and correct other issues.

What issues does it address?

=over 4

=item 1. Fail processing of GLOB-based objects

the Storable manpage would fail. For example:

    use IO::File;
    use Storable ();
    my $io = IO::File->new( __FILE__, 'r' );
    my $serialised = Storable::freeze( $io );

would yield the fatal error:

    Can't store GLOB items

and if you set `$Storable::forgive_me' to a true value, as pointed out in the Storable manpage documentation, this would yield:

    Can't store item GLOB(0x563f92a2cc48)

And if you implemented a `STORABLE_freeze' in the hope you could return an acceptable value to `Storable::freeze' upon freezing your glob-object, you are in for a disappointment. the Storable manpage would trigger the following fatal error. For example:

    use IO::File;
    use Storable ();
    sub IO::File::STORABLE_freeze {};
    $Storable::forgive_me = 1;
    my $io = IO::File->new( __FILE__, 'r' );
    my $serialised = Storable::freeze( $io );

would yield:

    Unexpected object type (8) in store_hook()

Completely obscure and unhelpful error and undocumented too. Whether `STORABLE_freeze' returns anything makes no difference.

=item 2. Fail processing of XS module objects

For example:

    use v5.36;
    use strict;
    use warnin...

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CHANGES LICENSE README.md TODO
%perl_vendor_privlib/S*

%changelog
