%define module_name Store-CouchDB
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dump.pm) perl(Data/Printer.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(LWP/Protocol/Net/Curl.pm) perl(LWP/UserAgent.pm) perl(Moo.pm) perl(MooX/Types/MooseLike/Base.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(URI.pm) perl(URI/Escape.pm) perl(URI/QueryParam.pm) perl(experimental.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 4.3
Release: alt1
Summary: a simple CouchDB driver
Group: Development/Perl
License: perl
URL: https://github.com/norbu09/Store-CouchDB/wiki

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LE/LEV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Store::CouchDB is a very thin wrapper around CouchDB. It is essentially
a set of calls I use in production and is by no means a complete
library, it is just complete enough for the things I need to do. This is
a grown set of functions that evolved over the last years of using
CouchDB in various projects and was written originally to be compatible
with DB::CouchDB. This has long passed and can only be noticed at some
places.

One of the things I banged my head against for some time is non UTF8
stuff that somehow enters the system and then breaks CouchDB. I use the
brilliant Encoding::FixLatin module to fix this on the fly.

    use Store::CouchDB;

    my $db = Store::CouchDB->new();
    $db->config({host => 'localhost', db => 'your_db'});
    my $couch = {
        view   => 'design_doc/view',
        opts   => { key => '"' . $key . '"' },
    };
    my $status = $db->get_array_view($couch);

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/S*

%changelog
