%define module_name Strict-Perl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Path.pm) perl(FindBin.pm) perl(Socket.pm) perl(Switch.pm) perl(Test.pm) perl(Thread.pm) perl(autodie.pm) perl(encoding.pm) perl(lib.pm) perl(strict.pm) perl(threads.pm) perl(vars.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2023.03
Release: alt1
Summary: Perl module to restrict old/unsafe constructs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IN/INA/Strict/Perl/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Strict::Perl provides a restricted scripting environment excluding old/unsafe
constructs, on both modern Perl and traditional Perl.

Strict::Perl works in concert with Fake::Our if Fake::Our is used in your
script.

Version specify is required when use Strict::Perl, like;

  use Strict::Perl 2014.05;

It's die if specified version doesn't match Strict::Perl's version.

On Perl 5.010001 or later, Strict::Perl works as;

  use strict;
  use warnings qw(FATAL all);
  use Fatal qw(
      seek sysseek
      dbmclose dbmopen
      binmode close chmod chown fcntl flock ioctl open sysopen truncate
      chdir closedir opendir link mkdir readlink rename rmdir symlink
      pipe
      msgctl msgget msgrcv msgsnd
      semctl semget semop
      shmctl shmget shmread
      accept bind connect getsockopt listen recv send setsockopt shutdown socketpair
      fork
  );
  use autodie qw(
      read sysread syswrite
      fileno
  );

On Perl 5.006 or later,

  use strict;
  use warnings qw(FATAL all);
  use Fatal qw(
      seek sysseek
      dbmclose dbmopen
      binmode close chmod chown fcntl flock ioctl open sysopen truncate
      chdir closedir opendir link mkdir readlink rename rmdir symlink
      pipe
      msgctl msgget msgrcv msgsnd
      semctl semget semop
      shmctl shmget shmread
      accept bind connect getsockopt listen recv send setsockopt shutdown socketpair
      fork
  );

On Perl 5.00503 or later,

  use strict;
  $^W = 1;
  $SIG{__WARN__} = sub { die "$_[0]\n" };
  use Fatal qw(
      seek sysseek
      dbmclose dbmopen
      binmode close chmod chown fcntl flock ioctl open sysopen truncate
      chdir closedir opendir link mkdir readlink rename rmdir symlink
      pipe
      msgctl msgget msgrcv msgsnd
      semctl semget semop
      shmctl shmget shmread
      accept bind connect getsockopt listen recv send setsockopt shutdown socketpair
      fork
  );

Prohibited Keywords in your script are;

  goto  redo  until  foreach
  format  write  formline
  msgctl  msgget  msgrcv  msgsnd
  semctl  semget  semop
  shmctl  shmget  shmread  shmwrite
  given  when

Prohibited Special Variables are;

  $ARRAY_BASE                        $[
  $OFMT                              $#
                                     @F
                                     $^H
  $OUTPUT_FIELD_SEPARATOR   $OFS     $,
  $OUTPUT_RECORD_SEPARATOR  $ORS     $\
  $LIST_SEPARATOR                    $"
  $SUBSCRIPT_SEPARATOR      $SUBSEP  $;
  $MULTILINE_MATCHING                $*
  $PREMATCH                          $`
  $MATCH                             $&
  $POSTMATCH                         $'
  $FORMAT_PAGE_NUMBER                $%%
  $FORMAT_LINES_PER_PAGE             $=
  $FORMAT_LINES_LEFT                 $-
  $FORMAT_NAME                       $~
  $FORMAT_TOP_NAME                   $^
  $FORMAT_LINE_BREAK_CHARACTERS      $:
  $FORMAT_FORMFEED                   $^L
  $ACCUMULATOR                       $^A

Prohibited Operator is;

  ~~ (smartmatch)

Must Keyword in your script is;

  VERSION

Be useful software for you!


%prep
%setup -q -n %{module_name}-%{version}
#mkdir lib
#cp -a Strict lib

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README CONTRIBUTING
%perl_vendor_privlib/S*

%changelog
