%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(Test/More.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name String-Blender
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: flexible vocabulary-based generator of compound words (e.g. domain names).
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SK/SKORIKOV/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
`String::Blender' is an OO implementation of random generator of compound
words based on one or more priority driven word vocabularies. Originally the
module was created for the purpose of constructing new attractive thematic domain
names. Later it was used to improve dictionary attack tool.

Each vocabulary itself represents an array of single words not necessarily sorted.
All vocabularies are stored in an array within predefined order. `String::Blender'
provides ability to load vocabularies from plain text files or set them manually.

Resulting compound words are represented as an array of uniq strings which consist
of one or more vocabulary words placed in serial or random order; probably
prefixed, followed and/or separated by defined strings.

Construction of one compound word can be briefly described like this:

=over

=item * Define random number of elements within a given set of constraints.

=item * Address each vocabulary list in a row up to the defined number of
elements and take one random word per vocabulary. Once the number of future
component words exceeds the number of vocabularies, then take each next word
from random vocabulary.

=item * Concatenate selected words and/or join them with delimiter, add
prefix and postfix if defined.

=item * Check the length of the resulting word. Retry attempt if it's too long
or too short.

=back



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
