%define module_name String-Equivalence-Amharic
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build.pm) perl(Regexp/Ethiopic.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Normalization Utilities for Amharic.
Group: Development/Perl
License: perl
URL: https://github.com/dyacob/String-Equivalence-Amharic

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DY/DYACOB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Under the "three levels of Amharic spelling" theory, the
String::Equivalence::Amharic  package will take a canonical word (level one)
and generate level two words (the level of popular use).  The first member
of the returned array is the original string.  The last member of the returned
array is a regular expression that will match all renderings of the list.

The doc/index.html file presents a development of the downgrade rules applied.

The package is useful for some problems, it will produce orthographically
"legal" simplification and avoids improbable naive simplifications.
the Text::Metaphone::Amharic manpage of course over simplifies as it addresses a
different problem.  So while not to promote level 2 orthographies, in some
instances it is useful to generate level 2 renderings given a canonical
form.

You *must* start with the canonical spelling of a word as only downgrades
can occur.  Starting with a near canonical form and downgrading will generate
a shorter word list than you would have starting from the top.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes.md README.md LICENSE CONTRIBUTING.md Changes SECURITY.md doc examples
%perl_vendor_privlib/S*

%changelog
