# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(_charnames.pm)
# END SourceDeps(oneline)
%define module_name String-Super
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Compactor for superstrings
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LI/LION/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
use String::Super;

    my String::Super $super = String::Super->new;

    my $idx = $super->add_blob('Hello World!');
    my $idx = $super->add_utf8('Hello World!');
    my $res = $super->result;
    my $off = $super->offset(index => $idx);

This module tries to find the smallest superstring of a set of strings.
That is the smallest string that contains all the given strings.
As this is not a easy problem to solve this module tries to balance calculation complexity with result size.

Finding the smallest superstring is a common problem that has many applications.
It can be used as part of optimising executable sizes, as part of compression algorithms, string matching and analysis.

The general workflow is to prepare the input data and serialise them into blobs (the substrings),
adding them to an object of this module, asking the module to do it's magic, and then collecting both the result and the offset
for each blob into the result.

Data such as unicode strings, or other objects need to be encoded. This module works on raw 8 bit blobs (unless otherwise noted).
It is also totally 8 bit/binary safe.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING README Changes LICENSE
%perl_vendor_privlib/S*

%changelog
