# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Sub-Boolean
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000000
Release: alt2
Summary: make XS true/false subs
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Sub-Boolean

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz

%description
A good way to create fast true/false constants is:

  use constant { true => !!1, false => !!0 };

Or on newer Perls:

  use builtin qw( true false );

However these constants will throw a compile-time error if you call them
as a sub:

  if ( true(123) ) {
    ...;
  }

Sub::Boolean allows you to create subs which return true or false fast
as they're implemented in XS.

As a bonus, it can also generate subs which return undef or the empty list.

Each function created by this module will have a different refaddr, which 
means that using things like `set_prototype' or `set_subname' on one will
not affect others.

Boolean functions are really unlikely to be a bottleneck in most
applications, so the use cases for this module are very limited.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYRIGHT Changes CREDITS LICENSE examples
%perl_vendor_archlib/S*
%perl_vendor_autolib/*

%changelog
