%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Sub/Name.pm) perl(Symbol.pm) perl(Test/More.pm) perl(accessors.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.12
%define module_name Sub-Contract
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: Pragmatic contract programming for Perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/ER/ERWAN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Sub::Contract offers a pragmatic way to implement parts of the
programming by contract paradigm in Perl.

Sub::Contract is not a design-by-contract framework.

Sub::Contract aims at making it very easy to constrain subroutines
input arguments and return values in order to emulate strong type
checking at runtime.

Perl is a weakly typed language in which variables have a dynamic
content at runtime. A feature often wished for in such circumstances
is a way to define constraints on a subroutine's arguments and on its
return values. A constraint is basically a test that the specific
argument has to pass otherwise an error is raised.

For example, a subroutine `add()' that takes 2 integers and return
their sum could have constraints on both input arguments and on the
return value stating that they must be defined and be integers or else
we croak. That kind of tests is usually writen explicitely within the
subroutine's body, hence leading to an overflow of argument validation
code. With Sub::Contract you can move this code outside the subroutine
body in a relatively simple and elegant way. The code for `add()' and
its contract could look like:

    contract('add')
        ->in(\&is_integer,\&is_integer)
        ->out(\&is_integer)
        ->enable;

    sub add { return $_[0]+$_[1] }

Sub::Contract doesn't aim at implementing all the properties of
contract programming, but focuses on some that have proven handy in
practice and tries to do it with a simple syntax.

Perl also support calling contexts which can lead to tricky
bugs. Sub::Contract attempts to constrain even the calling context of
contracted subroutines so it match with what the subroutine is
expected to return.

With Sub::Contract you can specify a contract per subroutine (or
method).  A contract is a set of constraints on the subroutine's input
arguments, its returned values, or on a state before and after being
called. If one of these constraints gets broken at runtime, the
contract fails and a runtime error (die or croak) is emitted.

Contracts generated by Sub::Contract are objects. Any contract can be
disabled, modified, recompiled and re-enabled at runtime.

All new contracts are automatically added to a contract pool.  The
contract pool can be searched at runtime for contracts matching some
conditions.

A compiled contract takes the form of an anonymous subroutine wrapped
around the contracted subroutine. Since it is a very appropriate place
to perform memoization of the contracted subroutine's result,
contracts also offer memoizing/caching as an option.

There may be only one contract per subroutine. To modify a
subroutine's contract, you need to get the contract object for this
subroutine and alter it. You can fetch the contract by querying the
contract pool (see Sub::Contract::Pool).

The contract definition API is designed pragmatically. Experience
shows that contracts in Perl are mostly used to enforce some form of
argument type validation, hence compensating for Perl's lack of strong
typing, or to replace some assertion code.

In some cases, one may want to enable contracts during development,
but disable them in production to meet speed requirements (though this
is not encouraged). That is easily done with the contract pool.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install
rm %buildroot%perl_vendor_privlib/.DS_Store

%files
%doc Changes LICENSE README TODO
%perl_vendor_privlib/S*

%changelog
