%define module_name Sub-Middler
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Export/These.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4.0
Release: alt1
Summary: Middleware subroutine chaining
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRCLAW/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
A small module, facilitating linking together subroutines, acting as middleware
or filters into chains with low runtime overhead.

To achieve this, the  'complexity' is offloaded to the definition of
middleware/filters subroutines. They must be wrapped in subroutines
appropriately to facilitate the lexical binding of linking variables.

This differs from other 'sub chaining' modules as it does not use a loop
internally to iterate over a list of subroutines at runtime. As such there is
no implicit call to the next item in the chain. Each stage can run
synchronously or asynchronously or even not at all. Each element in the chain
is responsible for calling the next.

Finally the arguments and signatures at each stage of middleware are completely
user defined and are not interfered with by this module. This allows reuse of
the `@_' array in calling subsequent stages for ultimate performance if you
know what you're doing.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md README LICENSE examples
%perl_vendor_privlib/S*

%changelog
