%define module_version 0.2.10
%define module_name Sub-Throttler
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(EV.pm) perl(Export/Attrs.pm) perl(JSON/XS.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/Mock/Time.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Time/HiRes.pm) perl(parent.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.10
Release: alt1
Summary: Rate limit sync and async function calls
Group: Development/Perl
License: mit
URL: https://github.com/powerman/perl-Sub-Throttler

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POWERMAN/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
This module provide sophisticated throttling framework which let you delay
execution of any sync and async functions/methods based on any rules you
need.

You can use core features of this framework with usual sync application or
with application based on any event loop, but some throttling algorithms
may require specific event loop (like the Sub::Throttler::Rate::EV manpage).

The the section on "SYNOPSIS" shows basic usage example, but there are a lot of
advanced features: define which and how many resources each
function/method use depending not only on it name but also on it params,
normal and high-priority queues for throttled functions/methods, custom
wrappers with ability to free unused limits, write your own
functions/methods with smart support for throttling, implement own
throttling algorithms, save and restore current limits between different
executions of your app.

Basic use case: limit rate for downloading urls. Advanced use case: apply
complex limits for using remote API, which depends on how many items you
process (i.e. on some params of API call), use high-priority queue to
ensure login/re-login API call will be executed ASAP before any other
delayed API calls, cancel unused limits in case of failed API call to
avoid needless delay for next API calls, save/restore used limits to avoid
occasional exceeding the quota because of crash/restart of your app.
%prep
%setup -q -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/S*

%changelog
