%define module_name Sub-Versions
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/Hook.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Sub/Util.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test2/V0.pm) perl(XS/Parse/Keyword.pm) perl(base.pm) perl(exact.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.06
Release: alt1
Summary: Subroutine versioning syntactic sugar
Group: Development/Perl
License: artistic_2
URL: https://github.com/gryphonshafer/Sub-Versions

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRYPHON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides automatic syntactic sugar for simple subroutine versioning.
By specifying a version in the form "v#" as a subroutine attributes, this
module will perform a series of compile time symbol table surgeries so you
can call subroutines by explicit version or the latest version implicitly.

    use MyExampleClass;
    my $object = MyExampleClass->new;

    $object->simple_method;     # calls the latest version of the method
    $object->v1->simple_method; # calls version 1 of the method

Versions must be specified in the form `/v\d+/'. The exact version number you
use is irrelevant. The only importance is the relative value of the version
numbers to each other. The largest version number is considered the most
current version of the subroutine.

    package MyExampleClass;
    use Sub::Versions;

    sub simple_method : v1 {
        return 'version 1';
    }

    sub simple_method : v2 {
        return 'version 2';
    }
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE SECURITY.md README
%perl_vendor_privlib/S*

%changelog
