# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(PadWalker.pm) perl(Parse/Keyword.pm) perl(Smart/Match.pm) perl(Test/More.pm) perl(Test/Requires.pm) perl(Types/Standard.pm) perl(match/simple.pm)
# END SourceDeps(oneline)
%define module_version 0.008
%define module_name Switcheroo
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.008
Release: alt1
Summary: yet another switch statement for Perl
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Switcheroo

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module provides Perl with a switch statement. It's more reliable than
the the Switch manpage module (which is broken on recent versions of Perl anyway),
less confusing than `use feature 'switch'', and more powerful than
the Switch::Plain manpage (though Switch::Plain is significantly faster).

Switcheroo uses the Perl keyword API, which was introduced in Perl 5.14,
so this module does not work on older releases of Perl.

The basic grammar of the switch statement is as follows:

   switch ( TEST ) {
      case EXPR1: STATEMENT1;
      case EXPR2: STATEMENT2;
      default:    STATEMENT3;
   }

TEST is evaluated in scalar context. Each expression EXPR1, EXPR2, etc
is evaluated in list context. If TEST matches any of the expression,
then the statement following it is executed. Matching is performed by
the match::simple manpage, which is a simplified version of the Perl smart match
operator. If no match is successful, then the `default' statement is
executed.

`switch' is whole statement, so does not need to be followed by a
semicolon.

Within the switch block, `$_' is a read-only alias to the TEST
value.

That's the basics taken care of, but there are several variations...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT LICENSE README Changes
%perl_vendor_privlib/S*

%changelog
