# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/SSLeay.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(LWP/UserAgent.pm) perl(XML/Parser.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define module_version 1.02
%define module_name Switchvox-API
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: Perl interface to the Switchvox Extend API.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DW/DWP/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides a simple interface to interface with the Extend API on a Digium, Switchvox PBX. 
For more complete documentation on the entire Switchvox Extend API please visit http://developers.digium.com/switchvox.
For more information on the Digium, Switchvox PBX product please visit the project home page at http://www.switchvox.com.

Note: The `Switchvox::API' object is a subclass of the LWP::UserAgent manpage so you can use all functionality of LWP::UserAgent.
	
An example of requesting information about two accounts (1106,1107) from the Switchvox PBX.

	my $api = new Switchvox::API(
		hostname => '192.168.0.50',
		username => 'admin',
		password => 'your_admin_password'
	);

	my $response = $api->api_request(
		method		=> 'switchvox.extensions.getInfo',
		parameters	=> 
		{
			account_ids => 
			[
				{ 'account_id' => [1106,1107] }
			],
		}
	);

	if($response->{api_status} eq 'success')
	{
		my $extensions = $response->{api_result}{response}[0]{result}[0]{extensions}[0]{extension};
		foreach my $extension (@$extensions)
		{
			print "Extension:$extension->{number}, Full Name:$extension->{first_name} $extension->{last_name}\n";
		}
	}
	else
	{
		print "Encountered Errors:\n";
		foreach my $error ( @{$response->{api_errors}} )
		{
			print "-Code:$error->{code},Message:$error->{message}\n";
		}
	}


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
