# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Sys-Load
%define upstream_version 0.2

Name:		perl-%{upstream_name}
Version:	%{upstream_version}
Release:	alt7_29

Summary:	A perl5 module that indicate system load
License:	Artistic
Group:		Development/Perl
Url:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/authors/id/B/BA/BARABAS/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires:	perl-devel
Source44: import.info


%description
getload() returns 3 elements: representing load averages over 
the last 1, 5 and 15 minutes. On failure empty list is returned.
uptime() returns the system uptime in seconds. Returns 0 on 
failure.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

# Remove Local from path
find . -type f | xargs perl -p -i -e "s|/usr/local/|/usr/|g"

# lib64 fixes, don't add /usr/lib/X11 to linker search path
perl -pi -e "s|-L/usr/lib/X11||g;s|-L/usr/X11/lib||g;s|-L/usr/lib||g" Makefile.PL
perl -pi -e "s|(/usr/X11R6)/lib|\1/%{_lib}|g" Makefile.PL

%build
perl Makefile.PL INSTALLDIRS=vendor </dev/null
%make_build

%check
%ifnarch ppc
%{__make} test
%endif

%install
%makeinstall_std

%files
%doc README
%{perl_vendor_archlib}/auto/Sys/Load/Load.so
%{perl_vendor_archlib}/Sys/Load.pm


%changelog
