%define module_name Sys-OsPackage
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(File/Basename.pm) perl(File/Copy/Recursive.pm) perl(File/Path.pm) perl(File/Slurp.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(Module/Build.pm) perl(Perl/PrereqScanner/NotQuiteLite.pm) perl(Readonly.pm) perl(Sys/OsRelease.pm) perl(Term/ANSIColor.pm) perl(Test/CPAN/Changes.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Try/Tiny.pm) perl(autodie.pm) perl(local/lib.pm) perl(open.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4.0
Release: alt1
Summary: install OS packages and determine if CPAN modules are packaged for the OS
Group: Development/Perl
License: artistic_2
URL: https://github.com/ikluft/Sys-OsPackage

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IK/IKLUFT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
*Sys::OsPackage* is used for installing Perl module dependencies.
It can look up whether a Perl module is available under some operating systems' packages.
If the module is available as an OS package, it installs it via the packaging system of the OS.
Otherwise it runs CPAN to install the module.

The use cases of *Sys::OsPackage* include setting up systems or containers with Perl modules using OS packages
as often as possible. It can also be used fvor installing dependencies for a Perl script on an existing system.

OS packaging systems currently supported by *Sys::OsPackage* are the Linux distributions Alpine, Arch, Debian,
Fedora and OpenSuse.
Using the Sys::OsRelease manpage it's able to detect operating systems derived from a supported platform use the correct driver.

RHEL and CentOS are supported by the Fedora driver.
CentOS-derived systems Rocky and Alma are supported by recognizing them as derivatives.
Ubuntu is supported by the Debian driver.

Other packaging systems for Unix-like operating systems should be feasible to add by writing a driver module.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md README
%perl_vendor_privlib/S*
%perl_vendor_privlib/auto/*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
