# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Trait/Attribute/Derived.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name TV-Humax-Foxsat
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Parse metadata files from your Humax satellite TV receiver.
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SP/SPUDSOUP/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use TV::Humax::Foxsat::hmt_data;

  my $hmt_data = new TV::Humax::Foxsat::hmt_data();
  $hmt_data->raw_from_file('/path/to/TV Show_20121007_2159.hmt');

  printf "Recording %%s ran from %%s till %%s on %%s (channel %%d).\n",
    $hmt_data->progName,
    $hmt_data->startTime,
    $hmt_data->endTime,
    $hmt_data->ChanNameEPG,
    $hmt_data->ChanNum;

  my @epg_records = @{ $hmt_data->EPG_blocks() };
  my $epg_block = pop @epg_records;

  printf "The last show in the recording was of %%s starting at %%s for %%d minutes.\n",
    $epg_block->progName,
    $epg_block->startTime,
    ( $epg_block1->duration / 60 );

  printf "The show description is %%s\n", $epg_block->guideInfo;

Hmt files are meta data files used by Humax

NB: There is no support for modifying and saving hmt data files.
You should treat the fields as read only.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
