# BEGIN SourceDeps(oneline):
BuildRequires: perl(Compress/Zlib.pm) perl(DBM/Deep.pm) perl(Debug/Simple.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Uncompress/Unzip.pm) perl(LWP.pm) perl(Storable.pm) perl(Test/More.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define module_version 0.33
%define module_name TVDB-API
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.33
Release: alt1
Summary: API to www.thetvdb.com
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BE/BEHANW/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides an API to the TVDB database through the new published API..
=over 4

=item $tvdb = TVDB::API::new([APIKEY, [LANGUAGE]])

Create a TVDB::API object using `APIKEY' and using a default language
of `LANGUAGE'. Both these arguments are optional.

New can also be called with a hashref as the first argument.

  $tvdb = TVDB::API::new({ apikey    => $apikey,
                           lang      => 'en',
                           cache     => 'filename',
                           banner    => 'banner/path',
                           useragent => 'My useragent'
                        });

=item setApiKey(APIKEY);

Set the `APIKEY' to be used to access the web api for thetvdb.com

=item setLang(LANGUAGE);

Set the `LANGUAGE' to use when downloading data from thetvdb.com

=item setUserAgent(USERAGENT);

Set the `USERAGENT' to be used when downloading information from thetvdb.com

=item setBannerPath(PATH);

Set the path in which to save downloaded banner graphics files.

=item setCacheDB("$ENV{HOME}/.tvdb.db");

Set the name of the database file to be used to save data from thetvdb.com

=item getAvailableMirrors([NOCACHE]);

Get the list of mirror sites available from thetvdb.com. It returns a hashref
of arrays.  If `NOCACHE' is non-zero, then the mirrors are downloaded again
even if they are in the cache database already.

Returns:
  {
    xml => @xml_mirrors,
    banner => @banner_mirrors,
    zip => @zip_mirrors,
  }

=item setMirrors(MIRROR, [BANNER, [ZIP]])

Set the mirror site(s) to be used to download tv info. If `BANNER' or `ZIP'
or not specified, then `MIRROR' is used instead.

=item chooseMirrors([NOCACHE])

Choose a random mirror from the list of available mirrors.  If `NOCACHE' is
non-zero, then the mirrors are downloaded again even if they are in the cache
database already.

=item getConf([KEY])

Get configurable values by `KEY'.  If no `KEY' is specified, a hashref of all
values is returned.

=item setConf(KEY, VALUE) or setConf({KEY=>VALUE, ...})

Set configurable values by `KEY'/`VALUE' pair.  If a hashref is passed in,
all `KEY'/`VALUE' pairs in the hashref will be configured.

    maxSeason       => 50,          # Maximum allowed season
    maxEpisode      => 50,          # Maximum allowed episode
    minUpdateTime   => 3600*6,      # Used by getUpdate('now')
    minBannerTime   => 3600*24*7,   # Used by getBanner()
    minEpisodeTime  => 3600*24*7,   # Used by getEpisode()

=item getAvailableLanguages([NOCACHE])

Get a list of available languages, and return them in a hashref.  If `NOCACHE'
is non-zero, then the available languages are downloaded again even if they are
in the cache database already.

=item getUpdates([PERIOD])

Get appropriate updates (day/week/month/all) from thetvdb.com based on the
specified `PERIOD'.  It then downloads updates for series, episodes, and
banners which have already been downloaded.

=over 4

=item `day'

Get the updates for the last 24 hours (86400 seconds).

=item `week'

Get the updates for the last week (7 days, or 604800 seconds).

=item `month'

Get the updates for the last month (30 days, or 2592000 seconds).

=item `all'

Get all updates available.

=item `now'

Based on the last update performed, determine whether to do a day, week, month
or all update.

=item `guess'

Like `now', based on the last update performed; determine whether to do a day,
week, month or all update.  However, if the last update was performed in the
last 6 hours (setable as `minUpdateTime' with setConf()), do nothing. This is
the default `PERIOD'.

=back

=item getPossibleSeriesId(SERIESNAME)

Get a list of possible series ids for `SERIESNAME' from thetvtb.com. This
will return a hashref of possibilities.

=item getSeriesId(SERIESNAME, [NOCACHE])

Get the series id (an integer) for `SERIESNAME' from thetvtb.com. If
`NOCACHE' is non-zero, then the series id is downloaded again even if it is in
the cache database already.

=item getSeriesName(SERIESID, [NOCACHE])

Get the series name (a string) for `SERIESID'. If `NOCACHE' is non-zero, then
the series name is downloaded again even if it is in the cache database
already.

=item getSeries(SERIESNAME, [NOCACHE])

Get the series info for `SERIESNAME' from thetvtb.com, which is returned as a
hashref. If `NOCACHE' is non-zero, then the series info is downloaded again
even if it is in the cache database already.

=item getSeriesAll(SERIESNAME, [NOCACHE])

Get the series info, and all episodes for `SERIESNAME' from thetvtb.com, which
is returned as a hashref. If `NOCACHE' is non-zero, then the series info and
episodes are downloaded again even if they are in the cache database already.

=item getSeriesActors(SERIESNAME, [NOCACHE])

Get the actors for `SERIESNAME' from thetvtb.com, which is returned as a
hashref. If `NOCACHE' is non-zero, then the list of actors are
downloaded again even if they are in the cache database already.

=item getSeriesActorsSorted(SERIESNAME, [NOCACHE])

Get the actors for `SERIESNAME' from thetvtb.com, which is returned as an
arrayref sorted by SortOrder.  If `NOCACHE' is non-zero, then the list of
actors are downloaded again even if they are in the cache database already.

=item getSeriesBanners(SERIESNAME, TYPE, TYPE2, VALUE, [NOCACHE])

Get the banners for `SERIESNAME' from thetvtb.com. Info about the available
banners are returned in a hashref.  The actual banners can be downloaded
individually with `getBanner' (see below).  If `NOCACHE' is non-zero, then
the list of banners are downloaded again even if they are in the cache database
already.

if `TYPE' is specified (series, season, poster, or fanart) then only return
banners of that type.  if `TYPE2' is specified then only return banners of
that sub type.  If `TYPE' is "series" then `TYPE2' can be "text",
"graphical", or "blank".  If `TYPE' is "season" then `TYPE2' can be "season",
or "seasonwide" and `VALUE' specifies the season number.  If `TYPE' is
"fanart" then `TYPE2' is the desired resolution of the image.

=item getSeriesInfo(SERIESNAME, KEY, [NOCACHE])

Return a string for `KEY' in the hashref for `SERIESNAME'.  If `NOCACHE' is
non-zero, then the series is downloaded again even if it is in the cache database already.

=item getSeriesBanner(SERIESNAME, [BUFFER, [NOCACHE]])

Get the `SERIESNAME' banner from thetvdb.com and save it in the `BannerPath'
directory.  The cached banner is updated via `getUpdates' when appropriate. If
a `BUFFER' is provided (a scalar reference), the banner (newly downloaded, or
from the cache) is loaded into it. If `NOCACHE' is non-zero, then the banner
is downloaded again even if it is in the `BannerPath' directory already. It
will return the path of the banner relative to the `BannerPath' directory.

=item getSeriesFanart(SERIESNAME, [BUFFER, [NOCACHE]])

Get the `SERIESNAME' fan art from thetvdb.com and save it in the `BannerPath'
directory.  The cached fan art is updated via `getUpdates' when appropriate.
If a `BUFFER' is provided (a scalar reference), the fan art (newly downloaded,
or from the cache) is loaded into it. If `NOCACHE' is non-zero, then the fan
art is downloaded again even if it is in the `BannerPath' directory already.
It will return the path of the fan art relative to the `BannerPath' directory.

=item getSeriesPoster(SERIESNAME, [BUFFER, [NOCACHE]])

Get the `SERIESNAME' poster from thetvdb.com and save it in the `BannerPath'
directory.  The cached poster is updated via `getUpdates' when appropriate.
If a `BUFFER' is provided (a scalar reference), the poster (newly downloaded,
or from the cache) is loaded into it. If `NOCACHE' is non-zero, then the
poster is downloaded again even if it is in the `BannerPath' directory
already. It will return the path of the poster relative to the `BannerPath'
directory.

=item getSeriesOverview(SERIESNAME, [NOCACHE])

Get the series overview from thetvdb.com and return it as a string. If
`NOCACHE' is non-zero, then the banner is downloaded again even if it is in
the cache database already.

=item getBanner(BANNER, [BUFFER, [NOCACHE]])

Get the `BANNER' from thetvdb.com and save it in the `BannerPath' directory.
The cached banner is updated via `getUpdates' when appropriate. If a `BUFFER'
is provided (a scalar reference), the picture (newly downloaded, or from the
cache) is loaded into it. If `NOCACHE' is non-zero, then the banner is
downloaded again even if it is in the `BannerPath' directory already. It will
return the path of the picture relative to the `BannerPath' directory.  In
this case it will just be the same as `BANNER'.

The `minBannerTime' configuration variable determines the maximum time a
banner download failure will be cached.  (see getConf()/setConf()).

=item getMaxSeason(SERIESNAME, [NOCACHE])

Return the number of the last season for `SERIESNAME'.  If `NOCACHE' is
non-zero, then any series info needed to calculate this is downloaded again
even if it is in the cache database already.

=item getSeason(SERIESNAME, SEASON, [NOCACHE])

Return a hashref of episodes in `SEASON' for `SERIESNAME'.  If `NOCACHE' is
non-zero, then any episodes needed for this season is downloaded again even if
it is in the cache database already.

The `maxSeason' configuration variable determines the maximum allowable season
(see getConf()/setConf()).

=item getSeasonBanners(SERIESNAME, SEASON, [NOCACHE])

Return an array of banner names for `SEASON' for `SERIESNAME'.  These names
can get used with `getBanner()' to actually download the banner file. If
`NOCACHE' is non-zero, then any data needed for this is downloaded again even
if it is in the cache database already.

=item getSeasonBanner(SERIESNAME, SEASON, [BUFFER, [NOCACHE]])

Get a random banner for `SEASON' for `SERIESNAME'.  The cached banner is
updated via `getUpdates' when appropriate.  If a `BUFFER' is provided (a
scalar reference), the banner (newly downloaded, or from the cache) is loaded
into it.  If `NOCACHE' is non-zero, then the banner is downloaded again even
if it is in the `BannerPath' directory already. It will return the path of the
banner relative to the `BannerPath' directory.

=item getSeasonBannersWide(SERIESNAME, SEASON, [NOCACHE])

Return an array of wide banner names for `SEASON' for `SERIESNAME'.  These
names can get used with `getBanner()' to actually download the banner file. If
`NOCACHE' is non-zero, then any data needed for this is downloaded again even
if it is in the `BannerPath' directory already.

=item getSeasonBannerWide(SERIESNAME, SEASON, [BUFFER, [NOCACHE]])

Get a random banner for `SEASON' for `SERIESNAME'.  The cached banner is
updated via `getUpdates' when appropriate.  If a `BUFFER' is provided (a
scalar reference), the banner (newly downloaded, or from the cache) is loaded
into it.  If `NOCACHE' is non-zero, then the banner is downloaded again even
if it is in the `BannerPath' directory already. It will return the path of the
banner relative to the `BannerPath' directory.

=item getMaxEpisode(SERIESNAME, SEASON, [NOCACHE])

Return the number episodes in `SEASON' for `SERIESNAME'.  If `NOCACHE' is
non-zero, then any series info needed to calculate this is downloaded again
even if it is in the cache database already.

The `maxEpisode' configuration variable determines the maximum allowable
episode (see getConf()/setConf()).

=item getEpisode(SERIESNAME, SEASON, EPISODE, [NOCACHE])

Return a hashref for the `EPISODE' in `SEASON' for `SERIESNAME'.  If
`NOCACHE' is non-zero, then the episode is downloaded again even if it is in
the cache database already.

The `minEpisodeTime' configuration variable determines the maximum time a
episode lookup failure will be cached.  (see getConf()/setConf()).

=item getEpisodeAbs(SERIESNAME, ABSEPISODE, [NOCACHE])

Return a hashref for the absolute episode (`ABSEPISODE') for `SERIESNAME'.
If `NOCACHE' is non-zero, then the episode is downloaded again even if it is
in the cache database already.

=item getEpisodeDVD(SERIESNAME, SEASON, EPISODE, [NOCACHE])

Return a hashref for the `EPISODE' in `SEASON' for `SERIESNAME' in DVD
order.  If `NOCACHE' is non-zero, then the episode is downloaded again even if
it is in the cache database already.

=item getEpisodeId(EPISODEID, [NOCACHE])

Return a hashref for the episode indicated by `EPISODEID'.  If `NOCACHE' is
non-zero, then the episode is downloaded again even if it is in the
cache database already.

=item getEpisodeByAirDate(SERIESNAME, AIRDATE [NOCACHE])

Return a hashref for the episode in `SERIESNAME' on `AIRDATE'. `AIRDATE' can
be specified as:

    2008-01-01
    2008-1-1
    January 1, 2008
    1/1/2008

Currently this lookup is not cached.  However, if `NOCACHE' is non-zero, then
the `SERIESNAME' to seriesid lookup is downloaded again.

=item getEpisodeInfo(SERIESNAME, SEASON, EPISODE, KEY, [NOCACHE])

Return a string for `KEY' in the hashref for `EPISODE' in `SEASON' for
`SERIESNAME'.  If `NOCACHE' is non-zero, then the episode is downloaded again
even if it is in the cache database already.

=item getEpisodeBanner(SERIESNAME, SEASON, EPISODE, [BUFFER, [NOCACHE]])

Get the episode banner for `EPISODE' in `SEASON' for `SERIESNAME'.  The
cached banner is updated via `getUpdates' when appropriate.  If a `BUFFER' is
provided, the picture (newly downloaded, or from the cache) is loaded into it.
If `NOCACHE' is non-zero, then the banner is downloaded again even if it is in
the `BannerPath' directory already. It will return the path of the picture
relative to the `BannerPath' directory.

=item getEpisodeName(SERIESNAME, SEASON, EPISODE, [NOCACHE])

Return the episode name for `EPISODE' in `SEASON' for `SERIESNAME'.  If
`NOCACHE' is non-zero, then the episode is downloaded again even if it is in
the cache database already.

=item getEpisodeOverview(SERIESNAME, SEASON, EPISODE, [NOCACHE])

Return the overview for `EPISODE' in `SEASON' for `SERIESNAME'.  If
`NOCACHE' is non-zero, then the episode is downloaded again even if it is in
the cache database already.

=item getRatingsForUser(USERID, SERIESNAME, [NOCACHE])

Get the series ratings for `USERID'. If `SERIESNAME' is specified, the
user/community ratings for the series and its episodes are returned in a
hashref.  If `SERIESNAME' is not specified, then all the series rated by the
<USERID> will be returned in a hashref.  These lookups are not cached.

=item dumpCache()

Dump the cache database with Dumper to stdout.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
