# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper/Concise.pm) perl(Exporter.pm) perl(FindBin.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(MooX/Types/MooseLike/Base.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Text/CSV.pm) perl(utf8/all.pm)
# END SourceDeps(oneline)
%define module_name Table-BoxFormat
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Parsing the tabular data format generated by database SELECTs
Group: Development/Perl
License: perl
URL: https://github.com/doomvox/table-boxformat

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DO/DOOM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Table::BoxFormat is a module to work with data in the tabular text
format(s) commonly used in database client shells (postgresql's
"psql", mysql's "mysql", or sqlite's "sqlite3"),
where a SELECT will typical display data in a form such as this (mysql):

  +-----+------------+---------------+-------------+
  | id  | date       | type          | amount      |
  +-----+------------+---------------+-------------+
  |  11 | 2010-09-01 | factory       |   146035.00 |
  |  15 | 2011-01-01 | factory       |   191239.00 |
  |  16 | 2010-09-01 | marketing     |   467087.00 |
  |  17 | 2010-10-01 | marketing     |   409430.00 |
  +-----+------------+---------------+-------------+

Or this (postgresql's "ascii" form):

   id |    date    |   type    | amount
  ----+------------+-----------+--------
    1 | 2010-09-01 | factory   | 146035
    4 | 2011-01-01 | factory   | 191239
    6 | 2010-09-01 | marketing | 467087
    7 | 2010-10-01 | marketing | 409430

These formats are human-readable, but not suitable for other
purposes such as feeding to a graphics program, or inserting into
another database table.

This code presumes these text tables of "data boxes" are either
stored in a string or saved to a file.

This code works with at least three different
formats: mysql, psql and unicode psql.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/T*

%changelog
