# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name TableData-Lookup
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Lookup value in a table data structure
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/TableData-Lookup

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use TableData::Lookup qw(
     table_vlookup
 );

 # exact matching
 table_vlookup(
   table => [
     {min_income=>      0, tax_rate=>0.13},
     {min_income=>  8_000, tax_rate=>0.18},
     {min_income=> 15_000, tax_rate=>0.22},
     {min_income=> 35_000, tax_rate=>0.30},
     {min_income=> 85_000, tax_rate=>0.39},
     {min_income=>140_000, tax_rate=>0.45},
   ],
   lookup_field => 'min_income',
   lookup_value => 35_000,
   result_field => 'tax_rate',
 ); # => 0.30

 # exact matching, not found
 table_vlookup(
   table => [
     {min_income=>      0, tax_rate=>0.13},
     {min_income=>  8_000, tax_rate=>0.18},
     {min_income=> 15_000, tax_rate=>0.22},
     {min_income=> 35_000, tax_rate=>0.30},
     {min_income=> 85_000, tax_rate=>0.39},
     {min_income=>140_000, tax_rate=>0.45},
   ],
   lookup_field => 'min_income',
   lookup_value => 40_000,
   result_field => 'tax_rate',
 ); # => undef

 # approximate matching
 table_vlookup(
   table => [
     {min_income=>      0, tax_rate=>0.13},
     {min_income=>  8_000, tax_rate=>0.18},
     {min_income=> 15_000, tax_rate=>0.22},
     {min_income=> 35_000, tax_rate=>0.30},
     {min_income=> 85_000, tax_rate=>0.39},
     {min_income=>140_000, tax_rate=>0.45},
   ],
   lookup_field => 'min_income',
   lookup_value => 40_000,
   result_field => 'tax_rate',
   approx => 1,
 ); # => 0.30

 # approximate matching & interpolated result
 table_vlookup(
   table => [
     {min_income=>      0, tax_rate=>0.13},
     {min_income=>  8_000, tax_rate=>0.18},
     {min_income=> 15_000, tax_rate=>0.22},
     {min_income=> 35_000, tax_rate=>0.30},
     {min_income=> 85_000, tax_rate=>0.39},
     {min_income=>140_000, tax_rate=>0.45},
   ],
   lookup_field => 'min_income',
   lookup_value => 40_000,
   result_field => 'tax_rate',
   approx => 1,
   interpolate => 1,
 ); # => 0.309

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/T*

%changelog
