# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Method/Modifiers.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Role/Tiny.pm) perl(Role/Tiny/With.pm) perl(Role/TinyCommons/Iterator/Resettable.pm) perl(TableDataRole/Source/CSVInFile.pm) perl(TableDataRole/Spec/Basic.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name TableData-Perl-CPAN-Release-Static-2021
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 20210928.2
Release: alt1
Summary: CPAN releases for the year 2021
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/TableData-Perl-CPAN-Release-Static-2021

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
To use from Perl code:

 use TableData::Perl::CPAN::Release::Static::2021;

 my $td = TableData::Perl::CPAN::Release::Static::2021->new;

 # Iterate rows of the table
 $td->each_row_arrayref(sub { my $row = shift; ... });
 $td->each_row_hashref (sub { my $row = shift; ... });

 # Get the list of column names
 my @columns = $td->get_column_names;

 # Get the number of rows
 my $row_count = $td->get_row_count;

See also the TableDataRole::Spec::Basic manpage for other methods.

To use from command-line (using the tabledata manpage CLI):

 # Display as ASCII table and view with pager
 %% tabledata Perl::CPAN::Release::Static::2021 --page

 # Get number of rows
 %% tabledata --action count_rows Perl::CPAN::Release::Static::2021

See the the tabledata manpage CLI's documentation for other available actions and options.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/T*
%perl_vendor_privlib/auto/*

%changelog
