Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Task-Moose
Version:        0.03
Release:        alt2_37
Summary:        Moose in a box
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Task-Moose
Source0:        https://cpan.metacpan.org/authors/id/D/DO/DOY/Task-Moose-%{version}.tar.gz
BuildArch:      noarch


BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
# Moose and Moose extentions are listed in Makefile.PL
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(MooseX/StrictConstructor.pm)
BuildRequires:  perl(MooseX/Params/Validate.pm)
BuildRequires:  perl(MooseX/Role/TraitConstructor.pm)
BuildRequires:  perl(MooseX/Traits.pm)
BuildRequires:  perl(MooseX/Object/Pluggable.pm)
BuildRequires:  perl(MooseX/Role/Parameterized.pm)
BuildRequires:  perl(MooseX/GlobRef.pm)
BuildRequires:  perl(MooseX/InsideOut.pm)
BuildRequires:  perl(MooseX/Singleton.pm)
BuildRequires:  perl(MooseX/NonMoose.pm)
BuildRequires:  perl(MooseX/Declare.pm)
BuildRequires:  perl(MooseX/Method/Signatures.pm)
BuildRequires:  perl(MooseX/Types.pm)
BuildRequires:  perl(MooseX/Types/Structured.pm)
BuildRequires:  perl(MooseX/Types/Path/Class.pm)
BuildRequires:  perl(MooseX/Types/Set/Object.pm)
BuildRequires:  perl(MooseX/Types/DateTime.pm)
BuildRequires:  perl(MooseX/Getopt.pm)
BuildRequires:  perl(MooseX/ConfigFromFile.pm)
BuildRequires:  perl(MooseX/SimpleConfig.pm)
BuildRequires:  perl(MooseX/App/Cmd.pm)
BuildRequires:  perl(MooseX/Role/Cmd.pm)
BuildRequires:  perl(MooseX/LogDispatch.pm)
BuildRequires:  perl(MooseX/LazyLogDispatch.pm)
BuildRequires:  perl(MooseX/Log/Log4perl.pm)
BuildRequires:  perl(MooseX/POE.pm)
BuildRequires:  perl(MooseX/Workers.pm)
BuildRequires:  perl(MooseX/Daemonize.pm)
BuildRequires:  perl(MooseX/Param.pm)
BuildRequires:  perl(MooseX/Iterator.pm)
BuildRequires:  perl(MooseX/Clone.pm)
BuildRequires:  perl(MooseX/Storage.pm)
BuildRequires:  perl(Moose/Autobox.pm)
BuildRequires:  perl(MooseX/ClassAttribute.pm)
BuildRequires:  perl(MooseX/SemiAffordanceAccessor.pm)
BuildRequires:  perl(namespace/autoclean.pm)
BuildRequires:  perl(Pod/Coverage/Moose.pm)
# Listed on Task::Moose man page
BuildRequires:  perl(TryCatch.pm)
# Tests
BuildRequires:  perl(Test/More.pm)

Requires:       perl(Moose.pm) >= 0.920
# Make Moose Stricter
Requires:       perl(MooseX/StrictConstructor.pm) >= 0.080
Requires:       perl(MooseX/Params/Validate.pm) >= 0.060
# Traits / Roles
Requires:       perl(MooseX/Role/TraitConstructor.pm)
Requires:       perl(MooseX/Traits.pm)
Requires:       perl(MooseX/Object/Pluggable.pm)
Requires:       perl(MooseX/Role/Parameterized.pm)
# Instance Types
Requires:       perl(MooseX/GlobRef.pm)
Requires:       perl(MooseX/InsideOut.pm)
Requires:       perl(MooseX/Singleton.pm) >= 0.200
Requires:       perl(MooseX/NonMoose.pm) >= 0.060
# Declarative Syntax
Requires:       perl(MooseX/Declare.pm)
Requires:       perl(MooseX/Method/Signatures.pm)
Requires:       perl(TryCatch.pm)
# Types
Requires:       perl(MooseX/Types.pm) >= 0.200
Requires:       perl(MooseX/Types/Structured.pm)
Requires:       perl(MooseX/Types/Path/Class.pm)
Requires:       perl(MooseX/Types/Set/Object.pm)
Requires:       perl(MooseX/Types/DateTime.pm)
# Command Line Integration
Requires:       perl(MooseX/Getopt.pm)
Requires:       perl(MooseX/ConfigFromFile.pm)
Requires:       perl(MooseX/SimpleConfig.pm)
Requires:       perl(MooseX/App/Cmd.pm)
Requires:       perl(MooseX/Role/Cmd.pm)
# Logging
Requires:       perl(MooseX/LogDispatch.pm)
Requires:       perl(MooseX/LazyLogDispatch.pm)
Requires:       perl(MooseX/Log/Log4perl.pm)
# Async
Requires:       perl(MooseX/POE.pm)
Requires:       perl(MooseX/Workers.pm)
# Utility Roles
Requires:       perl(MooseX/Daemonize.pm)
Requires:       perl(MooseX/Param.pm)
Requires:       perl(MooseX/Iterator.pm)
Requires:       perl(MooseX/Clone.pm)
Requires:       perl(MooseX/Storage.pm)
# Other Useful Extensions
Requires:       perl(Moose/Autobox.pm)
Requires:       perl(MooseX/ClassAttribute.pm)
Requires:       perl(MooseX/SemiAffordanceAccessor.pm)
Requires:       perl(namespace/autoclean.pm) >= 0.090
# Utilities
Requires:       perl(Pod/Coverage/Moose.pm)
Source44: import.info


%description
This Task installs Moose and a number of Moose extensions.

%prep
%setup -q -n Task-Moose-%{version}
rm -r inc
sed -i -e '/^inc\// d' MANIFEST
find -type f -exec chmod -x {} +

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor </dev/null
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT 
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
