# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Remove.pm) perl(File/Spec/Functions.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name Task-RecycleTrash
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Check/install the dependencies for File::Remove::trash
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADAMK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The trash function was added to the File::Remove manpage to provide access to
various operating system's native "holding area" for deleted files.

On Mac OS X this is known as the "trash" bin, on Windows this is known as
the "recycle" bin.

Unfortunately, the dependencies needed to interact with this functionality
can be quite difficult in several cases, most notably on Mac OS X where the
the Mac::Glue manpage (and thus the Mac::Carbon manpage) module is needed.

This created the rediculous situation in which a Mac OS X machine would
need to install and (audibly) test a voice synthesis engine in order to add
the capability to reliably delete a file.

To resolve this problem, the "trash" functionality in the File::Remove manpage will
ultimately be moved to a seperate distribution, but in the short term the
dependencies for the trash function will simply not be declared.

Task::RecycleTrash provides a replacement dependency for people that
genuinely do need to use the trash function in the File::Remove manpage.

It will install the dependencies needed on each platform, and then run some
simple tests to ensure that the trash function is working as intended.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/T*

%changelog
