%define module_name TeX-Hyphen-Pattern
BuildRequires: perl-podlators
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(File/Slurp.pm) perl(File/Temp.pm) perl(HTTP/Tiny/Cache.pm) perl(Log/Log4perl.pm) perl(Module/Build.pm) perl(Module/Pluggable.pm) perl(Module/Signature.pm) perl(Moose.pm) perl(Perl/Tidy.pm) perl(Pod/Usage.pm) perl(Progress/Any.pm) perl(Progress/Any/Output.pm) perl(Readonly.pm) perl(Set/Scalar.pm) perl(TeX/Hyphen.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/TestCoverage.pm) perl(Test/Warn.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.8
Release: alt1
Summary: class for providing a collection of TeX hyphenation
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IP/IPENBURG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
The the TeX::Hyphen manpage module parses TeX files containing hyphenation patterns for
use with TeX based systems. This module includes TeX hyphenation files from
http://www.ctan.org and hyphenation patterns from
http://www.openoffice.org and provides a single interface to use them in
the TeX::Hyphen manpage.

=over 4

=item http://tug.org/svn/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/

=item http://svn.services.openoffice.org/ooo/trunk/dictionaries/

=back

%prep
%setup -q -n %{module_name}-v%{version}
rm -f t/[0-9][-_]signature.t t/[0-9][0-9][-_]signature.t t/[0-9]signature.t t/[0-9][0-9]signature.t t/signature.t
rm -f t/[0-9][-_]Signature.t t/[0-9][0-9][-_]Signature.t t/[0-9][0-9][0-9][-_]Signature.t t/[0-9]Signature.t t/[0-9][0-9]Signature.t t/[0-9][0-9][0-9]Signature.t t/Signature.t
rm -f t/[0-9][-_]manifest.t t/[0-9][0-9][-_]manifest.t t/[0-9][0-9][0-9][-_]manifest.t t/[0-9]manifest.t t/[0-9][0-9]manifest.t t/[0-9][0-9][0-9]manifest.t t/manifest.t
rm -f t/[0-9][-_]MANIFEST.t t/[0-9][0-9][-_]MANIFEST.t t/[0-9][0-9][0-9][-_]MANIFEST.t t/[0-9]MANIFEST.t t/[0-9][0-9]MANIFEST.t t/[0-9][0-9][0-9]MANIFEST.t t/MANIFEST.t
rm -f t/[0-9][-_]check_manifest.t t/[0-9][0-9][-_]check_manifest.t t/[0-9][0-9][0-9][-_]check_manifest.t t/[0-9]check_manifest.t t/[0-9][0-9]check_manifest.t t/[0-9][0-9][0-9]check_manifest.t t/check_manifest.t

%build
%perl_vendor_build

%install
%perl_vendor_install
# strange perls in '#!'
fix_shabang_in_perl()
{
	local f="$1"
	#!/usr/bin/perl -w -- -*- mode: cperl -*-
	sed -i -e '1s,^#\![[:space:]]*\(/usr\)\?/bin/env[[:space:]]*perl,#!/usr/bin/perl,;1s,-\*-[[:space:]]*cperl[[:space:]]*-\*-,,;1s,-\*-[[:space:]]*[Mm]ode:[[:space:]]*[Cc]?[pP]erl[[:space:]]*-\*-,,' $f 
	sed -i -e '1s,^#\!/usr/local/bin/perl,#!/usr/bin/perl,' $f 
}
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) fix_shabang_in_perl $f 
	    ;;
	  esac
	done
	find $dir -type f \( -name '*.pm' -or -name '*.pl' \) | while read f; do
	  fix_shabang_in_perl $f
	done
    fi
done


%files
%doc LICENSE README Changes
%perl_vendor_privlib/T*

%changelog
