%define module_name Template-Compiled
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Alias.pm) perl(Eval/TypeTiny.pm) perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Entities.pm) perl(Moo.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Type/Params.pm) perl(Types/Standard.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: templates which compile into coderefs
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Template-Compiled

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Template::Compiled allows you to define a template which will be compiled
into a coderef that renders the template, filling in values. Templates
can contain variables and chunks of Perl code.

Technically, the template is an object which overloads `&{}' so that
it can act like a coderef, but you can get a real coderef by calling
`$template->sub'.

Compiling the coderef might be slower than some other template modules,
but rendering the template should be pretty much as fast as a pure Perl
template module can get. So in a persistent environment, where the same
template may be used over and over, this should be pretty fast.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYRIGHT CREDITS Changes LICENSE examples
%perl_vendor_privlib/T*

%changelog
