%define module_name Template-Lace
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(JSON/MaybeXS.pm) perl(JSON/XS.pm) perl(Module/Runtime.pm) perl(Mojo/DOM58.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Template/Tiny.pm) perl(Test/Most.pm) perl(UUID/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.017
Release: alt1
Summary: Logic-less, strongly typed, and componentized HTML templates.
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Template-Lace

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Template::Lace manpage is a toolkit that makes it possible to bind HTML templates to plain old Perl
classes as long as they provide a defined interface (provided by the Template::Lace::ModelRole manpage
but you don't have to use the Moo manpage as long as you conform to the minimal interface). These
templates are fully HTML markup only; they contain no display logic, only valid HTML and component
declarations.  We use the Template::Lace::DOM manpage (which is a subclass of the Mojo::DOM58 manpage) to alter the 
template for presentation at request time.  the Template::Lace::DOM manpage provides an API to transform
the template into HTML using instance data and methods provided by the class.  See the class
the Template::Lace::DOM manpage and the Mojo::DOM58 manpage for more about how these classes allow you to inspect
and modify a DOM.

When you have a Perl class that does the Template::Lace::ModelRole manpage we call that a 'Model' class
Here's an example of a very simple Model class:

    package  MyApp::Template::User;

    use Moo;
    with 'Template::Lace::ModelRole';

    has [qw/age name motto/] => (is=>'ro', required=>1);

    sub template { q[
      <html>
        <head>
          <title>User Info</title>
        </head>
          <body>
            <dl id='user'>
              <dt>Name</dt>
              <dd id='name'> -NAME- </dd>
              <dt>Age</dt>
              <dd id='age'> -AGE- </dd>
              <dt>Motto</dt>
              <dd id='motto'> -MOTTO- </dd>
            </dl>
          </body>
      </html>
    ]}

    sub process_dom {
      my ($self, $dom) = @_;
      $dom->dl('#user', +{
        age=>$self->age,
        name=>$self->name,
        motto=>$self->motto});
    }

    1;

In this example the Model class defines two methods, `process_dom' and `template'.  Any Perl class
can be used as Model class as long as it provides these methods (as well as a stub for `prepare_dom'
which will we discuss later; or just consume the Template::Lace::ModelRole manpage.)  The `template...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn LICENSE README TODO Changes examples
%perl_vendor_privlib/T*

%changelog
