# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Module/Build/Tiny.pm) perl(Template/Liquid.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.0.6
%define module_name Template-LiquidX-Tag-Dump
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.6
Release: alt1
Summary: Simple Perl Structure Dumping Tag (Functioning Custom Tag Example)
Group: Development/Perl
License: artistic_2
URL: https://github.com/sanko/Template-LiquidX-Tag-Dump

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SA/SANKO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This is a dead simple demonstration of
extending Template::Liquid.

This tag attempts to use the Data::Dump manpage and the Data::Dumper manpage to create
stringified versions of data structures...

    use Template::Liquid;
    use Template::LiquidX::Tag::Dump;
    warn Template::Liquid->parse("{%%dump env%%}")->render(env => \%%ENV);

...or the entire current scope with `.'...

    use Template::Liquid;
    use Template::LiquidX::Tag::Dump;
    warn Template::Liquid->parse('{%%dump .%%}')
        ->render(env => \%%ENV, inc => \@INC);

...or the entire stack of scopes with `.*'...

    use Template::Liquid;
    use Template::LiquidX::Tag::Dump;
    warn Template::Liquid->parse('{%%for x in (1..1) %%}{%%dump .*%%}{%%endfor%%}')
        ->render();
        
...becomes (w/ Data::Dump installed)...

    do {
      my $a = [
        [
          {
            forloop => {
              first   => 1,
              index   => 1,
              index0  => 0,
              last    => 1,
              length  => 1,
              limit   => 1,
              name    => "x-(1..1)",
              offset  => 0,
              rindex  => 1,
              rindex0 => 0,
              sorted  => undef,
              type    => "ARRAY",
            },
            x => 1,
          },
          'fix',
        ],
      ];
      $a->[0][1] = $a->[0][0];
      $a;
    }

Notice even the internal `forloop' variable is included in the dump.        


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/T*

%changelog
