# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Class/constr.pm) perl(IO/Util.pm) perl(CGI.pm)
# END SourceDeps(oneline)
%define module_version 1.4
%define module_name Template-Magic
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.4
Release: alt1
Summary: Template using dynamic scoped vars and more
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SK/SKNPP/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Template::Magic is a "magic" interface between programming and design. It makes "magically" available all the runtime values - stored in your variables or returned by your subroutines - inside a static template file. In simple cases there is no need to assign values to the object. Template outputs are linked to runtime values by their *identifiers*, which are added to the template in the form of simple *labels* or *blocks* of content..
    a label: {identifier}
    a block: {identifier} content of the block {/identifier}

From the designer point of view, this makes things very simple. The designer has just to decide what value and where to put it. Nothing else is required, no complicated new syntax to learn! This feature make this template system the perfect choice when the templates file has to be edited by unskilled people.

On the other side, the programmer has just to define variables and subroutines as usual and their values will appear in the right place within the output. The automatic interface allows the programmer to focus just on the code, saving him the hassle of interfacing code with output, and even complicated output - with complex switch branching and nested loops - can be easily organized by minding just a few simple concepts.

=over

=item 1

The object parses the template and searches for any *labeled zone*

=item 2

When a *zone* is found, the object looks into your code and searches for any variable or sub with the same identifier (name)

=item 3

When a match is found the object replaces the label or the block with the value returned by the variable or sub found into your code (dereferencing and/or executing code as needed). (see the section on "Understand the output generation" for details)

=back

Note: If you are planning to use this module in CGI environment, take a look at CGI::Builder::Magic that transparently integrates this module in a very handy and powerful framework.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*
%perl_vendor_privlib/B*

%changelog
