%define module_name Template-Plex
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Error/Show.pm) perl(Export/These.pm) perl(ExtUtils/MakeMaker.pm) perl(Log/OK.pm) perl(Log/ger.pm) perl(Test/More.pm) perl(constant/more.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9.0
Release: alt1
Summary: Templates in (P)erl using (Lex)ical Aliasing
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRCLAW/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module is a mechanism to facilitate the use of perl (not embedded perl) as
a text processing template language. 

Conceptually, a `Template::Plex' template is just a string returned from a
subroutine in perl's double quoted context, with the outer operators removed:
_
_#PERL
_"This is is a perl string interpolating @{[ map uc, qw<a b c d>]}"

_#  or

_qq{This is is a perl string interpolating @{[ map uc, qw<a b c d>]}}
_

_#PLEX template. Same as PERL syntax, without the outer double quotes
_This is is a perl string interpolating @{[ map uc, qw<a b c d>]};

_#OUTPUT is the same for all of the above:
_This is is a perl string interpolating A B C D


Because of the powerful and flexible interpolation of strings in perl, you can
do just about anything in a Plex template. After all the template is just perl. 

The 'lexical' part of this modules refers to ability of variables to be
aliased into the template (more on this later). It improves the style and usage
of variables in a template while also allowing sub templates to access/override
variables using lexical scoping.

Some feature highlights:

=over

=item * Templates are written in perl syntax

=item * Templates are compiled into a perl subroutine

=item * Lexical and package variables accessed/created within templates

=item * Call and create subroutines within templates

=item * 'Include' Templates within templates easily

=item * Recursive and conditional sub template loading

=item * Declare variables and subroutines in templates

=item * `use' other modules directly in templates

=back

To get started after installation, copy the following lines into perl and execute:

_use strict;
_use warnings;
_use feature "say";
_use Template::Plex;
_my %%vars=(name=>"Susan", age=>99);
_my $template=plex ['this is ${name}\'s inline template. $age young'], \%%vars;
_say $template->render;
_
_@vars{qw<name age>}=qw<Richard 23>;
_say $template->render;

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md README Changes examples
%perl_vendor_privlib/T*

%changelog
