# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/Format/Flexible.pm) perl(ExtUtils/MakeMaker.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Weaver/Section/Contributors.pm) perl(Template.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/V0.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Template-Plugin-AutoDate
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.90
Release: alt1
Summary: Enhance Template Toolkit with easy access to DateTime and DateTime::Format::Flexible
Group: Development/Perl
License: perl
URL: https://github.com/IntelliTree/perl-Template-Plugin-AutoDate

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NERDVANA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to access the full power of the DateTime manpage from within
Template Toolkit.  Since you don't always have date objects in the data,
it also allows you to coerce arbitrary strings into DateTime using
the DateTime::Format::Flexible manpage.

When you use this plugin, it installs two vmethods into your current Template
context:

=over

=item coerce_date

This can be called on any scalar, and it will parse the scalar with
the DateTime::Format::Flexible manpage.  It returns `undef' if the string cannot be
parsed, allowing you to continue chaining calls on it and get TT's behavior
for undefined values.

If called on an actual DateTime object, it returns the DateTime object
un-altered.

=item strftime

When called on a scalar, this coerces it to a DateTime, and if defined, then
calls the strftime method on it.  This means you can now
call `strftime' on any date field you like regardless of whether it's been
inflated to a DateTime object by your controller.

=back

It also provides an object (which inherits from DateTime) which you can call
methods on.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes README.md
%perl_vendor_privlib/T*

%changelog
