Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Template-Plugin-Cycle
Version:        1.06
Release:        alt3_44
Summary:        Cyclically insert into a Template from a sequence of values
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Template-Plugin-Cycle
Source0:        https://cpan.metacpan.org/authors/id/A/AD/ADAMK/Template-Plugin-Cycle-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  sed
# Runtime
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(Params/Util.pm)
BuildRequires:  perl(Template.pm)
BuildRequires:  perl(Template/Plugin.pm)
BuildRequires:  perl(vars.pm)
# Tests only
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Params/Util.pm) >= 0.200
Requires:       perl(Template.pm) >= 2.100


Source44: import.info
%filter_from_requires /^perl(Params.Util.pm)/d

%description
Sometimes, apparently almost exclusively when doing alternating table row
backgrounds, you need to print an alternating, cycling, set of values into
a template.

Template::Plugin::Cycle is a small, simple, and hopefully DWIM solution to
these sorts of tasks.

%prep
%setup -q -n Template-Plugin-Cycle-%{version}
# Remove bundled modules
rm -r ./inc/*
sed -i -e '/^inc\//d' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
