# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBM/Deep.pm) perl(ExtUtils/MakeMaker.pm) perl(Template/Plugin.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Template-Plugin-DBM-Deep
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Template Toolkit plugin for DBM::Deep
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/ME/MERLYN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module permits the direct use of `DBM::Deep', a persistent.sharable store for nearly arbitrarily nested hashes and arrays, within
Template Toolkit code.

The initial constructor returns the top-level `DBM::Deep' object.
All keyword arguments are passed to the `DBM::Deep' constructor as a
flat list. Any single positional argument is presumed to be the
`file' keyword parameter, permitting simple invocations like:

  USE db = DBM.deep("my.db");

All appropriate method calls described in the OO Interface entry in the DBM::Deep manpage
are available.  In addition, hash-like objects can use direct keys
to get at values:

  db.foo = "bar";
  db.foo; # gets "bar"

And array-like objects can use direct indicies:

  db.mylist = ["a" "b" "c"];
  db.mylist.2; # gets "c"

Caution: VMethods do not work against the hash-like or
array-like objects.  However, you can use the `export' method to get
an unattached cloned copy of that portion of the database, and then
the normal vmethods work:

  "$key\n" FOR key IN db.export.keys;

Failure to `export' first will result in attempting to access a hash
element called `keys', which doesn't exist.

There are probably other limitations.  If you find other weirdness,
let me know so I can update this document.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
