# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA2.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(Template.pm) perl(Template/Plugin.pm) perl(Template/Stash.pm) perl(Template/Test.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Template-Plugin-Digest-SHA2
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: TT2 interface to the SHA2 Algorithm
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BA/BARBIE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The *Digest.SHA2* Template Toolkit plugin provides access to the NIST SHA-1
algorithm via the `Digest::SHA2' module.  It is used like a plugin but
installs filters and vmethods into the current context.

When you invoke

    [%% USE Digest.SHA2 %%]

the following filters (and vmethods of the same name) are installed
into the current context:

=over 4

=item `sha2'

Calculate the SHA-2 digest of the input, and return it in binary form.

=item `sha2_hex'

Same as `sha2', but will return the digest in hexadecimal form. The returned
string will only contain characters from this set: '0'..'9' and 'a'..'f'.

=item `sha2_base64'

Same as `sha2', but will return the digest as a base64 encoded string. The
returned string will only contain characters from this set: 'A'..'Z', 'a'..'z',
'0'..'9', '+' and '/'.

=back

As the filters are also available as vmethods the following are all
equivalent:

    FILTER sha2_hex; content; END;
    content FILTER sha2_hex;
    content.sha2_base64;
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
