# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Class/C3.pm) perl(Config.pm) perl(Cwd.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Schema.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Template.pm) perl(Template/Constants.pm) perl(Template/Plugin.pm) perl(Template/Provider/FromDATA.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(mro.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name Template-Plugin-Heritable
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: OO dispatching and inheritance for templates
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SAMV/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
`Template::Plugin::Heritable' provides support for selecting an
appropriate template based on the class of an object.  It is also
possible to call the next template in the inheritance heirarchy/chain.

This provides a form of inheritance for template display.

The core of this is the *template dispatch* mechanism, which deals in
terms of a suitable metamodel class.  The module currently deals in
the following metamodels;

=over 4

=item the T2::Class manpage

T2 is a metamodel system for Tangram starting with the Class::Tangram manpage.

=item the Class::MOP manpage

Initial support for the Class::MOP manpage classes.  Note that this is
currently only tested with the Moose manpage; in particular it assumes
Moose-like type constraints.  If you want support for plain
Class::MOP, please send a test case.

=item the mro manpage

Perl 5.10 introduces this module, allowing all classes to specify
their *method resolution order*.  This only provides enough
information to call `invoke' without an attribute name, for there is
still no attribute type information available in Perl 5.

=item the DBIx::Class::ResultSet manpage

A ResultSet is something akin to a class, but missing exactly what
the mro manpage isn't; it does not have inheritance.  The only thing that you
can inherit over is the classes that were used to construct your
model classes (ie, all the DBIx::Class internal classes).

There is something of a case that sometimes, a one-to-one relationship
is the same thing as an inheritance relationship.  However it is not
guaranteed that is a correct interpretation of a one to one
relationship; class dispatch does not use it, for instance.

Anyway, it doesn't really matter - this "metamodel" is treated just
the same as the the mro manpage plugin when it comes to generating a list of
classes that go into the dispatch_paths list.  The only thing this
support does differently is know how to fetch the column types from
the ResultSet definition of the class.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_privlib/T*

%changelog
