%define module_name Template-Provider-HTTP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(HTTP/Server/Simple/CGI.pm) perl(LWP/UserAgent.pm) perl(Template.pm) perl(Test/HTTP/Server/Simple.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt2
Summary: fetch templates from a webserver
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KK/KKANE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Templates usually live on disk, but this is not always ideal. This module lets
you serve your templates over HTTP from a webserver.

For our purposes we wanted to access the latest templates from a Subversion
repository and have them update immediately.

ABSOLUTE = 1 when passed to the constructor acts as a helper to support full 
path to your http template.  "Full" path begins at the domain 
name(omit http://):

    use Template;
    use Template::Provider::HTTP;
    
    my $tt = Template->new( { LOAD_TEMPLATES => [
        Template::Provider::HTTP->new( ABSOLUTE => 1 ) ], } );
    $tt->process( 'www.example.com/templates/my_template.html', \%%vars );

EXPAND_RELATIVE = 1 when passed to the constructor will attempt to expand
relative paths in the source document into absolute paths.  For example:
    href="../../main.css" will turn into: 
    href="http://www.someurl.tld/some/path/../../main.css"

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/T*

%changelog
