%define module_name Term-ANSIColor-Conditional
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Term/ANSIColor.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.009
Release: alt1
Summary: Colorize text only if color is enabled
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Term-ANSIColor-Conditional

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a wrapper for the Term::ANSIColor manpage. If color is enabled then
everything is the same as Term::ANSIColor. If color is disabled, then `color()'
will emit empty string and `colored()' will not colorize input text.

How to determine "color is enabled":

=over

=item * If package variable `$Term::ANSIColor::Conditional::COLOR' is defined, use that.

=item * Otherwise, check if `COLOR' environment variable is defined and use that.

=item * Otherwise, check if (-t STDOUT) is true (interactive terminal). If yes, color is enabled.

=item * Otherwise, color is disabled.

=back

=for Pod::Coverage ^(.+)$

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
