%define module_name Term-App-Util-Color
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Term/App/Util/Interactive.pm) perl(Term/Detect/Software.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Determine color depth and whether to use color or not
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Term-App-Util-Color

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
FUNCTIONS
  term_app_color_depth
    Usage:

     term_app_color_depth() -> [status, msg, payload, meta]

    Try to determine the suitable color depth to use. Will first check
    COLOR_DEPTH environment variable and use that if defined. Otherwise will
    check COLOR environment variable and use that as color depth if defined
    and the value looks like color depth (e.g. 256 or "24bit"). Otherwise
    will try to detect terminal emulation software and use the highest
    supported color depth of that terminal software. Otherwise will default
    to 16.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/T*

%changelog
