Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Curses.pm) perl(sys/ioctl.ph) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       perl-Term-Completion 
Version:    1.00
Release:    alt2_30
License:    GPL-1.0-or-later OR Artistic-1.0-Perl
Summary:    Read one line of user input, with convenience functions 
Source:     https://cpan.metacpan.org/authors/id/M/MA/MAREKR/Term-Completion-%{version}.tar.gz
Url:        https://metacpan.org/release/Term-Completion
# Fixed handling of spaces and tabs after the end of completed file (CPAN RT#121992)
Patch0:     Term-Completion-1.00-Fix-handling-of-spaces-and-tabs.patch
BuildArch:  noarch
BuildRequires: findutils
BuildRequires: perl-devel
BuildRequires: rpm-build-perl
BuildRequires: perl(base.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IO/String.pm)
BuildRequires: perl(POSIX.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(Term/ReadKey.pm)
BuildRequires: perl(Term/Size.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(warnings.pm)


Source44: import.info

%description
Term::Completion is an extensible, highly configurable replacement for
the venerable Term::Complete package. It is object-oriented and thus allows
subclassing. Two derived classes are Term::Completion::Multi and 
Term::Completion::Path. A prompt is printed and the user may enter one line
of input, submitting the answer by pressing the ENTER key. 

%prep
%setup -q -n Term-Completion-%{version}
%patch0 -p1
find . -type f -exec chmod -c -x {} \;
perl -pi -e 's|^#!/opt/perl_5.8.8/bin/perl|#!%{__perl}|' devel/tget.pl
for file in README Changes devel/*; do
    sed -i 's/\r//g' ${file}
done

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} %{buildroot}/*

%check
# needed for testing...
export COLUMNS=80
export LINES=25
make test

%files
%doc Changes README devel/
%{perl_vendor_privlib}/*

%changelog
