Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Term-Prompt
Version:        1.04
Release:        alt3_45
Summary:        Perl extension for prompting a user for information
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Term-Prompt
Source0:        https://cpan.metacpan.org/authors/id/P/PE/PERSICOM/Term-Prompt-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Runtime
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Term/ReadKey.pm)
BuildRequires:  perl(Text/Wrap.pm)
BuildRequires:  perl(warnings.pm)
# Tests only
BuildRequires:  perl(Test/More.pm)
Source44: import.info

%description
This main function of this module is to accept interactive input. You
specify the type of inputs allowed, a prompt, help text and defaults and it
will deal with the user interface, (and the user!), by displaying the
prompt, showing the default, and checking to be sure that the response is
one of the legal choices. Additional 'types' that could be added would be a
phone type, a social security type, a generic numeric pattern type...

%prep
%setup -q -n Term-Prompt-%{version}
for f in $(find . -type f); do
    chmod a-x -c $f
    perl -pi -e 's/\r//g' $f
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
