%define module_name Term-Spinner-Color
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Pod/Usage.pm) perl(Term/ANSIColor.pm) perl(Term/Cap.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: A terminal spinner/progress bar with Unicode, color, and no non-core dependencies.
Group: Development/Perl
License: bsd
URL: https://github.com/SwellJoe/perl-Term-Spinner-Color

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SW/SWELLJOE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a simple spinner, useful when you want to show some kind of activity
during a long-running process of indeterminant length.  It's loosely based
on the API from the Term::Spinner manpage and the Term::Spinner::Lite manpage.  Unlike
the Term::Spinner manpage though, this module doesn't have any dependencies outside
of modules shipped with Perl itself. And, unlike the Term::Spinner::Lite manpage, this
module has color support and support for wide progress bars.

This module also provides an asynchronous mode, which does not require your
program to manually call the `next' method.

Some features and some (Unicode) frame sets do not work in Windows PowerShell
or cmd.exe. If you must work across a wide variety of platforms, choosing
ASCII frame sets is wise. `run_ok' method currently only provides Unicode
output, so it is not suitable for use on Windows (bash, of many types, on
Windows works fine, however). There's probably a way to fix this by switching
to another code page in Windows shells.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE examples
%perl_vendor_privlib/T*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
