%define module_name Term-TablePrint
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Scalar/Util.pm) perl(Term/Choose.pm) perl(Term/Choose/LineFold/XS.pm) perl(Term/Choose/Util.pm) perl(Term/Form/ReadLine.pm) perl(Test/More.pm) perl(constant.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.173
Release: alt1
Summary: Print a table to the terminal.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KU/KUERBIS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`print_table' prints a table to `STDOUT' or to `STDERR' if `STDOUT' is redirected.

`print_table' provides a cursor which highlights the row on which it is located. The user can scroll through the table
with the different cursor keys - see the KEYS entry elsewhere in this document.

If the table has more rows than the terminal, the table is divided up on as many pages as needed automatically.
If the cursor reaches the end of a page, the next page is shown automatically (until the last page is reached). Also if
the cursor reaches the topmost line, the previous page is shown automatically if it is not already the first one.

If the terminal is too narrow to print the table, the columns are adjusted to the available width automatically.
If the option *table_expand* is enabled and a row is selected with `Return' each column of that row is output in its
own line preceded by the column name. This might be useful if the columns were cut due to the too low terminal width.

To get a proper output `print_table' uses the `columns' method from the Unicode::GCString manpage to calculate the string
length.

The following modifications are made (at a copy of the original data) before the output.

Leading and trailing spaces are removed from the array elements

    s/^\p{Space}+//;
    s/\p{Space}+\z//;

and spaces are squashed to a single white-space.

    s/\p{Space}+/ /g;

In addition, characters of the Unicode property `Other' are removed.

    s/\p{C}//g;

In `Term::TablePrint' the utf8 warnings are disabled.

    no warnings 'utf8';

The elements in a column are right-justified if one or more elements of that column do not look like a number, else they
are left-justified.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
