Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Test-Apocalypse
Version:        1.006
Release:        alt2_27
Summary:        Apocalypse's favorite tests bundled into a simple interface
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Test-Apocalypse
Source0:        https://cpan.metacpan.org/authors/id/A/AP/APOCAL/Test-Apocalypse-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Capture/Tiny.pm)
BuildRequires:  perl(CPAN/Meta/Requirements.pm)
# Data::Dumper not used at tests
BuildRequires:  perl(Devel/PPPort.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Find/Rule.pm)
BuildRequires:  perl(File/Slurp.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Which.pm)
BuildRequires:  perl(JSON/Any.pm)
BuildRequires:  perl(Module/CPANTS/Analyse.pm)
BuildRequires:  perl(Module/Pluggable.pm)
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(Perl/Critic/Deprecated.pm)
BuildRequires:  perl(Perl/Critic/Itch.pm)
BuildRequires:  perl(Perl/Critic/Utils/Constants.pm)
BuildRequires:  perl(Perl/Metrics/Simple.pm)
BuildRequires:  perl(Perl/PrereqScanner.pm)
BuildRequires:  perl(Pod/Coverage/TrustPod.pm)
BuildRequires:  perl(Task/Perl/Critic.pm)
BuildRequires:  perl(Test/AutoLoader.pm)
BuildRequires:  perl(Test/Compile.pm)
BuildRequires:  perl(Test/ConsistentVersion.pm)
BuildRequires:  perl(Test/CPAN/Changes.pm)
BuildRequires:  perl(Test/CPAN/Meta.pm)
BuildRequires:  perl(Test/CPAN/Meta/JSON.pm)
BuildRequires:  perl(Test/CPAN/Meta/YAML.pm)
BuildRequires:  perl(Test/Deep.pm)
BuildRequires:  perl(Test/Dir.pm)
BuildRequires:  perl(Test/DistManifest.pm)
BuildRequires:  perl(Test/EOL.pm)
BuildRequires:  perl(Test/FailWarnings.pm)
BuildRequires:  perl(Test/File.pm)
BuildRequires:  perl(Test/Fixme.pm)
BuildRequires:  perl(Test/HasVersion.pm)
BuildRequires:  perl(Test/MinimumVersion.pm)
BuildRequires:  perl(Test/Mojibake.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/NoBreakpoints.pm)
BuildRequires:  perl(Test/NoPlan.pm)
BuildRequires:  perl(Test/Perl/Critic.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(Test/Pod/LinkCheck.pm)
BuildRequires:  perl(Test/Pod/No404s.pm)
BuildRequires:  perl(Test/Pod/Spelling/CommonMistakes.pm)
BuildRequires:  perl(Test/Portability/Files.pm)
BuildRequires:  perl(Test/Script.pm)
BuildRequires:  perl(Test/Signature.pm)
BuildRequires:  perl(Test/Spelling.pm)
BuildRequires:  perl(Test/Strict.pm)
BuildRequires:  perl(Test/Synopsis.pm)
BuildRequires:  perl(Test/Vars.pm)
BuildRequires:  perl(version.pm)
BuildRequires:  perl(YAML.pm)
BuildRequires:  perl(YAML/Any.pm)
# Tests:
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IPC/Open3.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Data/Dumper.pm)
Requires:       perl(Perl/Critic/Utils/Constants.pm)
Requires:       perl(Test/FailWarnings.pm)
Requires:       perl(Test/Portability/Files.pm)

# Remove under-specified dependenices

Source44: import.info
%filter_from_requires /^perl(Test.More.pm)/d

%description
This module greatly simplifies common author tests for modules heading towards
CPAN. I was sick of copy/pasting the tons of t/foo.t scripts + managing them
in every distribution. I thought it would be nice to bundle all of it into one
module and toss it on CPAN :) That way, every time I update this module all of
my distributions would be magically updated!

%prep
%setup -q -n Test-Apocalypse-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes CommitLog examples LICENSE README
%{perl_vendor_privlib}/*

%changelog
